YFind(1)                  User Commands                  YFind(1)



 NAME
     YFind - search a file for a pattern

 SYNOPSIS
      YFind [ -bchilnsvwBSV[0-9] ]  regular-expression
          [ filename ... ]


 DESCRIPTION
     The YFind command searches files for a  pattern  and  prints
     all  lines  that  contain  that  pattern.

     Normally, each line found is copied to standard output.  The
     file name is printed before each line found if there is more
     than one input file.

     Filenames can be specified with MS-DOS  "wild chars" such as
     * and ? (common in most MS-DOS applications for "any string"
     and "any character").


 OPTIONS
     The following options are supported:

       -S           Do not  interpret  the pattern  as a  regular
                    expression,  but as a plain text and  use the
		    Soundex  algorithm  (match words sounding the
		    same as the pattern).

       -[0-9]       Do not  interpret  the pattern  as a  regular
                    expression,  but as a plain text  and allow 0
		    (exact  match)   to  9  errors/approximations
		    (very imprecise match).

       -b           Precede each line  by  the  block  number  on
                    which  it  was  found.  This can be useful in
                    locating  block  numbers  by  context  (first
                    block is 0, each block is 512 bytes long).

       -c           Print only a count of the lines that  contain
                    the pattern.

       -f           Precede each line by the name of the file.

       -i           Ignore upper/lower  case  distinction  during
                    comparisons.

       -n           Precede each line by its line number  in  the
                    file (first line is 1).

       -B           Read all files as binary strings rather than
                    text lines (may be twice slower, but needed for
		    files containing NULL characters).

       -s           Suppress error messages about nonexistent  or
                    unreadable files

       -v           Print all lines except those that contain the
                    pattern.

       -V           Display  version number  of the  YGrep Search
                    Engine used.

       -?           Display  minimal help line  with the  list of
                    options.


 EXAMPLES
     To find all uses of the word "Posix" (in any  case)  in  the
     file  text.mm, and write with line numbers:

           example% YFind -i -n posix text.mm

     To find all empty lines in the standard input:

           example% YFind ^$
     or
           example% YFind -v .

     To find all uses of either "toto", "tota" or "toti"  in  the
     file  text.txt, and write with line numbers:

           example% YFind -1 -n toto text.txt

 EXIT STATUS
     The following exit values are returned:

       0            one or more matches were found

       1            no matches were found

       2            syntax errors or inaccessible files (even  if
                    matches were found).

 NOTES
     Lines  are  limited  to  1024  characters; longer  lines  are
     truncated.

     YFind  does not  use the  Soundex  algorithm  provided by the
     YGrep Search  Engine.  It is  limited  to  approximative  and
     regular expression searches.

     When conflicting options are set, the following order decides
     which one will be choosen:
      Most influential
        - Soundex (-S)
	- Approximative (-[1-9])
	- exact match (-0)
	- regular expressions (others)
      Least influential

 INSTALLATION
     YFind is to be installed in the same directory as YGrep32.DLL
     in order to  find it when needed for operation.  The simplest
     location is certainly the C:\WINDOWS directory.
